<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::group(
    [
        'namespace' => 'App\\Http\\Controllers\\Cliente',
        'prefix'    => 'client'
    ],
    function () {
        include __DIR__ . '/client/advisor.php';
        include __DIR__ . '/client/rating.php';
    }
);
Route::group(
    [
        'namespace' => 'App\\Http\\Controllers\\Admin',
        'prefix'    => 'admin'
    ],
    function () {
        include __DIR__ . '/admin/admin.php';
        include __DIR__ . '/admin/advisor.php';
        include __DIR__ . '/admin/rating.php';
        include __DIR__ . '/admin/session.php';
    }
);
