<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Symfony\Component\Console\Helper\Table;

class Rating extends Model
{
    public $timestamps = false;
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'IdRating',
        'ValueRating',
        'DateRating',
        'IdAdvisor',

    ];
    protected $casts       = [
        "DateRating"   => "datetime:c"
    ];
    protected $table = "rating";
    protected $primaryKey = 'IdRating';
    public function advisor()
    {
        return $this->belongsTo(Advisor::class, 'IdAdvisor', 'IdAdvisor');
    }

}
