<?php
namespace App\Http\Controllers\Admin\Session;
use App\Models\Session;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
class SessionIdController
{
    public static function staticIndex($TokenSession)
    {
        $now = Carbon::now();
        $result = Session::where('TokenSession', $TokenSession)
            ->where('statusSession', 1)
            ->get();
        if (count($result) > 0) {
            if ($now < $result[0]->DateStartSession || $now > $result[0]->DateEndSession) {
                return (object)[
                    'success' => false,
                    'errorMessage' => 'Token expired',
                    'IdAdmin' => null
                ];
            } else {
                $result[0]->DateEndSession=now()->addHours(24); 
                $result[0]->save();
                return (object)[
                    'success' => true,
                    'errorMessage' => ' ',
                    'IdAdmin' => $result[0]->IdAdmin
                ];
            }
        }
        return (object)[
            'success' => false,
            'errorMessage' => 'Token not found',
            'IdAdmin' => null
        ];
    }
    public function index(Request $request)
    {
        // dd(SessionIdController::index($request->header('token')));
        $result = Session::where('TokenSession', $request->header('token')) ->get();
        if (count($result)>0){
            return json_encode ( $result[0]);
        }
        else return json_encode (null);
    }
}
