<?php

namespace App\Http\Controllers\Admin\Advisor;

use App\Models\Advisor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Fail;
use Illuminate\Support\Facades\DB;
use App\Models\Success;
use GrahamCampbell\ResultType\Result;
use App\Providers\AdvisorProvider;

class AdvisorUpdateActiveController
{
    public function __construct(public AdvisorProvider $advisorProvider)
    {
    }
    public function index(Request $request, $IdAdvisor)
    {
        $validator = Validator::make($request->all(), [
            'ActiveAdvisor' => 'required|int|min:0|max:1',
        ]);
        if ($validator->fails()) {
            return json_encode(new Fail(
                false,
                $validator->errors()
            ));
        }
        $advisor = $this->advisorProvider->findAdvisor($IdAdvisor);
        if ($advisor == null) {
            return $this->advisorProvider->findAdvisorFail();
        }
        // --------------------------------------------------------------
        $advisor->ActiveAdvisor = $request->input('ActiveAdvisor');
        $advisor->save();
        return json_encode(new Success(
            true,
            "Successfully updated",
            (object)[
                "Id" => $advisor->IdAdvisor
            ]
        ));
    }
}
