<?php
namespace App\Http\Controllers\Admin\Advisor;
use App\Models\Advisor;
use App\Models\Fail;
use App\Models\Success;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
class AdvisorImageController
{
    public function upload(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'NameAdvisor' => 'required|string|max:50',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048'
        ]);
        if ($validator->fails()) {
            return json_encode( new Fail (
                success:false,
                error:$validator->errors()
            ));
        }
        $image = $request->file('image');  //garantiza que el nombre sea único
        $imageName =time() . '.' . $image->getClientOriginalExtension();
        $image->move(public_path(config('app.PRIVATE_URL') . 'images/advisor/'), $imageName); //la carpeta se guardará edn public/images
        // return response()->json(['success' => 'Image uploaded successfully']);
        
        $advisor = new Advisor();
        $advisor->NameAdvisor = $request-> input('NameAdvisor');
        $advisor->ImgAdvisor ='images/advisor/' . $imageName;
        $advisor->AverageAdvisor = -1;
        $advisor->ActiveAdvisor = 0;
        $advisor->save();

        return json_encode(new Success(
            true,
            "Successfully added",
            (object)[
                "Id"=>$advisor->IdAdvisor
            ]
            )
        );
    }
}
